#assign adapter is ftdi
adapter driver ftdi 

if { [info exists cJTAG] } {
    if {$cJTAG == 1} {
        ftdi nscan1_mode on
        echo "Enable cJTAG Mode"
    }
}

#gdb adapter port
if { [info exists gs32_adapter_speed] } {
	set _ADAPTER_SPEED $gs32_adapter_speed
} else {
	set _ADAPTER_SPEED 4000
}

#assign ftdi jtag speed uint:KHZ
adapter speed $_ADAPTER_SPEED
#assign adapter interface mode is jtag
transport select jtag

adapter list

if { [info exists gs32_adapter_serial] } {
	adapter serial $gs32_adapter_serial
}

#0.12.0
#assign vid pid
ftdi vid_pid 0x0403 0x6010

ftdi layout_init 0x0008 0x001b
ftdi layout_signal nSRST -oe 0x0020 -data 0x0020
ftdi layout_signal TCK -data 0x0001
ftdi layout_signal TDI -data 0x0002
ftdi layout_signal TDO -input 0x0004
ftdi layout_signal TMS -data 0x0008
ftdi layout_signal nTRST -data 0x0010
ftdi layout_signal JTAG_SEL -data 0x0100 -oe 0x0100

#cJTAG/JTAG select
if { [info exists cJTAG] } {
    if {$cJTAG == 1} {
        ftdi layout_signal JTAG_SEL -data 0x0100 -oe 0x0100
    }
}

#reset_config srst_only
#reset_config srst_nogate